﻿using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelInbound
{
    /// <summary>
    /// Get Appointment Type step.
    /// </summary>
    public class GetAppointmentTypeStep : FilterBase<MakeCancelInboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelInboundStateObject state)
        {
            if (state.ServiceAppointment.cvt_Type.HasValue && state.ServiceAppointment.cvt_Type.Value)
            {
                state.AppointmentType = AppointmentType.HOME_MOBILE;
            }
            else if (state.ServiceAppointment.mcs_groupappointment.HasValue && state.ServiceAppointment.mcs_groupappointment.Value)
            {
                state.AppointmentType = AppointmentType.GROUP;
                state.IsGroupAppointment = true;
            }
            else if (state.ServiceAppointment.cvt_TelehealthModality.HasValue && state.ServiceAppointment.cvt_TelehealthModality.Value)
            {
                state.AppointmentType = AppointmentType.STORE_FORWARD;
            }
            else
            {
                state.AppointmentType = AppointmentType.CLINIC_BASED;
            }
        }
    }
}